<?php

namespace App\Http\Requests;


class ChangePasswordRequest extends ApiRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'old' => ['required'],
            'new' => ['required', 'min:10', 'password_strength:2', 'confirmed'],
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'old' => 'Altes Passwort',
            'new' => 'Neues Passwort',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'new.required'          => 'Das Passwort muss ausgefüllt sein.',
            'new.min'               => 'Das Passwort muss mindestens :min Zeichen lang sein.',
            'new.password_strength' => 'Das Passwort ist zu schwach.',
        ];
    }
}