<?php

namespace App\Http\Requests;

use Illuminate\Support\Facades\Auth;

class CategoryRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        $category = $this->route('category');

        return Auth::user()->can($category ? 'edit categories' : 'create categories');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            'name'      => ['required', 'max:250'],
            'slug'      => ['required', 'regex:/^[a-z0-9_\-]+$/', 'max:250'],
            'parent_id' => ['integer', 'min:0', 'exists:categories,id'],
        ];

        $category = $this->route('category');
        if ($category) {
            $rules['parent_id'][] = 'not_in:' . $category->id;
        }

        return $rules;
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'parent_id.not_in' => 'Eine Kategorie kann nicht in einen eigenen Nachkommen verschoben werden',
        ];
    }
}
