<?php

namespace App\Http\Requests;

use Illuminate\Support\Facades\Auth;

class BankingDataRequest extends ApiRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        $user = Auth::user();

        return $user->hasRole('employee')
            ? $user->canDo('edit company data', true)
            : true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'iban'       => ['required', 'iban'],
            'iban_owner' => ['required', 'max:80'],
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'iban'       => 'IBAN',
            'iban_owner' => 'Kontoinhaber',
        ];
    }
}
