<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ApiRequest extends FormRequest
{
    /**
     * Method to return validation data. Returns parsed JSON if it request has JSON data, or usual request data if not.
     *
     * @return array
     */
    protected function validationData()
    {
        return count($this->json()->all()) ? $this->json()->all() : $this->all();
    }

    /**
     * Method to provide after event.
     *
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function getValidatorInstance()
    {
        return parent::getValidatorInstance()->after(function ($validator) {
            $this->after($validator);
        });
    }

    /**
     * Method to validate something after rules check.
     *
     * @param $validator
     */
    protected function after($validator)
    {
        //
    }
}