<?php

namespace App\Http\Requests;

use Illuminate\Support\Facades\Auth;

class AliasRequest extends ApiRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        $user = Auth::user();

        return $user->hasRole('employee')
            ? $user->canDo('edit company data', true)
            : true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $user   = Auth::user();
        $seller = Auth::user();

        if ( $user->hasRole('employee') ) {
            $seller = $user->boss;
        }

        return [
            'alias' => ['required', 'regex:/^[a-z0-9_\-]+$/', 'unique:users,alias,' . $seller->id],
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'alias' => 'Alias',
        ];
    }
}
