<?php

namespace App\Http\Requests;

use App\Account;
use App\Http\Requests\Request;
use Illuminate\Support\Facades\Auth;

class AccountRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if(Auth::user()->hasRole('operator')){
            $rules=[
                'zip' => [self::ZIP,'between:5,5'],
                'iban' => 'iban',
                'tax_id' => ['regex:/([a-zA-Z]{2}[0-9]{9}|[0-9]{2,3}(\/? ?)?[0-9]{3,4}(\/? ?)?[0-9]{4,5})/']
            ];
            return $rules;
        }
        $account = Account::where('id', '=', $_POST['id'])->first();
        //operator is editing someone
        if(Auth::user()->account != $account &&  Auth::user()->hasRole('operator') && $account != null){
            $accountUser = $account->users()->first();
            if($accountUser->hasRole('agent')){
                return [
                    'iban' => ['required','iban'],
                    'iban_owner' => ['required',self::IBAN_OWNER],
                    'company' => ['required',self::COMPANY],
                    'street' => ['required',self::STREET],
                    'housenumber' => ['required',self::HOUSENUMBER],
                    'zip' => ['required',self::ZIP,'between:5,5'],
                    'city' => ['required',self::CITY]
                ];
            }
            if($accountUser->hasRole('consumer')){
                return [
                    'iban' => ['required','iban'],
                    'iban_owner' => ['required',self::IBAN_OWNER]
                ];
            }
        }

        if(Auth::user()->hasRole('consumer') || Auth::user()->hasRole('agent')){
            return  [
                'iban' => ['required','iban'],
                'iban_owner' => ['required',self::IBAN_OWNER]
            ];
        }
        return  [
            'street' => ['required',self::STREET],
            'housenumber' => ['required',self::HOUSENUMBER],
            'zip' => ['required',self::ZIP,'between:5,5'],
            'city' => ['required',self::CITY],
            'iban' => ['required','iban'],
            'iban_owner' => ['required',self::IBAN_OWNER],
            'company' => ['required',self::COMPANY],
            'tax_id' => ['regex:/([a-zA-Z]{2}[0-9]{9}|[0-9]{2,3}(\/? ?)?[0-9]{3,4}(\/? ?)?[0-9]{4,5})/']
        ];
    }
}
