<?php

namespace App\Http\Middleware;

use App\Services\TFAService;
use Carbon\Carbon;
use Closure;

class TFA
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $user = auth()->user();
        $tfaService = new TFAService($user);

        if ( auth()->check() && $tfaService->needTwoFactorAuth() ) {
            if ( !$request->is('tfa*') ) {
                return redirect()->route('tfa.index');
            }
        }

        return $next($request);
    }
}
