<?php

namespace App\Http\Middleware;

use Closure;

class RedirectIfOnBoardingIncomplete
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        if(!auth()->check()) {
            return $next($request);
        }
        else{

            if ($request->user()->hasRole('seller') && $request->user()->account->needsOnBoarding()) {
                return redirect()->action('Onboarding\OnboardingSellerController@index');
            }elseif($request->user()->hasRole('agent') && $request->user()->account->needsOnBoarding()){
                return redirect()->action('Onboarding\OnboardingAgentController@index');
            }

            return $next($request);
        }
    }
}
