<?php

namespace App\Http\Middleware;

use Closure;

class HasRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \Closure $next
     * @param array $roles
     * @return mixed
     */
    public function handle($request, Closure $next, ...$roles)
    {
        if ( null === $request->user() ) {
            return redirect('/');
        }

        foreach ($roles as $role) {
            if ( $request->user()->hasRole($role) ) {
                return $next($request);
            }
        }

        return redirect('/');
    }
}
