<?php

namespace App\Http\Middleware;

use Closure;

class CanShowOnboardingSeller
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if($request->user()->hasRole('agent') && $request->user()->account->needsOnBoarding()){
            return redirect()->action('Onboarding\OnboardingAgentController@index');
        }
        return $next($request);
    }
}
