<?php

namespace App\Http\Middleware;

use Closure;

class CanShowOnboardingAgent
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if($request->user()->hasRole('seller') && $request->user()->account->needsOnBoarding()){
            return redirect()->action('Onboarding\OnboardingSellerController@index');
        }
        return $next($request);
    }
}
