<?php

namespace App\Http\Middleware;

use Closure;

class CanDo
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \Closure $next
     * @param $permission
     * @return mixed
     */
    public function handle($request, Closure $next, $permission)
    {
        if ( $request->user()->canDo($permission, true) ) {
            return $next($request);
        }

        return redirect('/');
    }
}
