<?php

namespace App\Http\Middleware;

use Auth;
use Closure;

class CanAnyMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, ...$permissions)
    {
        if (Auth::guest()) {
            return redirect(url('/'));
        }

        foreach ($permissions as $permission) {
            if ( $request->user()->fresh()->can($permission) ) { // ->fresh() workaround for stupid test framework
                return $next($request);
            }
        }

        return redirect(url('/'));
    }
}
