<?php

namespace App\Http\Middleware;


use Closure;
use Illuminate\Support\Facades\Auth;

class Active
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $user = Auth::user();

        if ( null === $user ) {
            return redirect('/');
        }

        if ( \App\User::STATUS_ACTIVE !== Auth::user()->status ) {
            Auth::logout();
            return redirect('/');
        }

        return $next($request);
    }
}