<?php

namespace App\Http\Grids\Seller;

use App\Account;
use App\Http\Grids\UserGrid;
use App\Invitation;
use App\Library\Facades\Format;
use App\Library\Grids\FieldConfig;
use App\Library\Grids\GridConfig;
use App\Rating;
use App\User;
use Illuminate\Support\Facades\Auth;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\FilterConfig;
use Nayjest\Grids\Grid;

class RatingGrid extends UserGrid
{
    public function __construct()
    {
        return parent::__construct($this->getGridConfig());
    }

    protected function getGridConfig()
    {
        return (new GridConfig)
            ->setDataProvider(
                new EloquentDataProvider($this->getGridQuery())
            )
            ->setName('ratings')
            ->setColumns($this->getGridColumns());
    }

    protected function getGridQuery()
    {
        $query = Rating::where('rated_account_id', '=', Auth::user()->account_id);

        return $query;
    }

    protected function getGridColumns()
    {
        $gridColumns = [
            (new FieldConfig)
                ->setName('rating')
                ->setLabel('Bewertung')
                ->setCallback(function ($val) {
                    return '<input data-size="l" class="output-rating" name="input-3"
                                                          value="{{$ownRating->rating}}"
                                                          class="rating-loading">';
                })
            ,
            (new FieldConfig)
                ->setName('description')
                ->setSortable(false)
                ->setLabel('Kommentar')
            ,
            (new FieldConfig)
                ->setName('user_id')
                ->setSortable(false)
                ->setLabel('Verbraucher')
                ->setCallback(function ($val) {
                    $user = User::find($val);
                    if(!$user){
                        return trans('translations.not-active');
                    }
                    return $user->getProfileLink('consumer');
                })
            ,
            (new FieldConfig)
                ->setName('created_at')
                ->setSortable(false)
                ->setLabel('am')
                ->setCallback(function ($val) {
                    return Format::date($val);
                })
        ];


        return $gridColumns;
    }
}