<?php

namespace App\Http\Grids\Seller;

use App\Http\Grids\AbstractAccountGrid;
use App\Library\Facades\Format;
use App\Library\Grids\FieldConfig;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Nayjest\Grids\Grid;

class MyAgentsGrid extends AbstractAgentGrid
{
    protected $_name = 'myagents';

    protected function getGridQuery()
    {
        return Auth::user()->account->availableAgentAccountsQuery();
    }

    protected function getGridColumns()
    {
        $gridColumns = parent::getGridColumns();

        $gridColumns['company']
            ->setLabel('Empfehler')
            ->setCallback(function ($val, $row) {
                    $account = $row->getSrc();
                    return $account->renderFullLink(User::AGENT);
            });

        /*
        $gridColumns[] =
            (new FieldConfig)
                ->setName('account_id')
                ->setLabel('Chatten')
                ->setCellHtmlAttributes(['class' => 'chat-label'])
                ->setSortable(false)
                ->setCallback(function ($val, $row) {
                    if ($val !== null) { // nicht "ohne Anfrage verfügbar"
                        $agentId = User::where('account_id',$val)->first()->id;
                        return '<a href="javascript:;" onclick="jqac.arrowchat.chatWith('.$agentId.');"><img class="chat-image-small" src="/img/icons/chat-bubble.svg"> </a>';
                    }
                    return '';

                });
        */

        $gridColumns[] =
            (new FieldConfig)
                ->setName('account_id')
                ->setLabel(' ')
                ->setCellHtmlAttributes(['class' => 'button-cell'])
                ->setSortable(false)
                ->setSorting(Grid::SORT_ASC)
                ->setCallback(function ($val) {
                    return '<a class="btn btn-white  delete-via-modal" data-delete-href="' . route('agent-account-remove', $val) . '"><i class="fa fa-trash-o"></i></a>';
                });
        return $gridColumns;
    }
}