<?php

namespace App\Http\Grids\Seller;

use App\Coupon;
use App\Library\Facades\Format;
use App\Library\Grids\FieldConfig;
use App\Library\Grids\GridConfig;
use App\User;
use App\Library\Grids\DefaultGrid;
use Illuminate\Support\Facades\Auth;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\FilterConfig;
use Nayjest\Grids\Grid;

class MultiCouponGrid extends DefaultGrid
{
    protected $_name = 'recbon-management';

    protected function getGridQuery()
    {
        return Auth::user()->couponsSharedFromThisSeller()->getQuery()
            ->addSelect(['coupons.*', 'coupons.status as couponStatus'])
            ->where('selection', '=', 1)
            ->groupBy('selection_group');
    }

    protected function getGridColumns()
    {

        $gridColumns = [
            (new FieldConfig)
                ->setName('agent_user_id')
                ->setLabel('Empfehler')
                ->setSorting(Grid::SORT_ASC)
                ->setCallback(function ($val) {
                    $user = User::whereId($val)->first();
                    if(!$user){
                        return trans('translations.not-active');
                    }else{
                        return $user->getProfileLink(User::AGENT);
                    }
                })
            ,
            (new FieldConfig)
                ->setName('consumer_user_id')
                ->setLabel('Verbraucher')
                ->setSorting(Grid::SORT_ASC)
                ->setCallback(function ($val, $row) {
                    if(!$row->getSrc()->consumer){
                        return trans('translations.not-active');
                    }else{
                        return $row->getSrc()->consumer->getProfileLink(User::CONSUMER);
                    }
                })
            ,
            (new FieldConfig)
                ->setName('created_at')
                ->setLabel('Empfohlen')
                ->setSorting(Grid::SORT_ASC)
                ->setSortable(true)
                ->setCallback(function ($val) {
                        return Format::date($val);
                })
        ];

        return $gridColumns;
    }
}