<?php

namespace App\Http\Grids\Seller;

use App\Coupon;
use App\Library\Facades\Format;
use App\Library\Grids\FieldConfig;
use App\Library\Grids\GridConfig;
use App\User;
use App\Library\Grids\DefaultGrid;
use Illuminate\Support\Facades\Auth;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\FilterConfig;
use Nayjest\Grids\Grid;

class CouponGrid extends DefaultGrid
{
    protected $_name = 'recbon-management';

    protected function getGridQuery()
    {
        return Auth::user()->couponsSharedFromThisSeller()->getQuery()
            ->addSelect(['coupons.*', 'coupons.status as couponStatus'])
            ->where('selection', '=', 0);
    }

    protected function getGridColumns()
    {

        $gridColumns = [
            (new FieldConfig)
                ->setName('coupons.title')
                ->setLabel('RECO.BON')
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                )
            ,
            (new FieldConfig)
                ->setName('consumer_user_id')
                ->setLabel('Verbraucher')
                ->setSortable(true)
                ->setCallback(function ($val, $row) {
                    if(!$row->getSrc()->consumer){
                        return trans('translations.not-active');
                    }else{
                        return $row->getSrc()->consumer->getProfileLink(User::CONSUMER);
                    }
                })
            ,
            (new FieldConfig)
                ->setName('agent_user_id')
                ->setLabel('Empfehler')
                ->setSorting(Grid::SORT_ASC)
                ->setCallback(function ($val, $row) {
                    if(!$row->getSrc()->agent){
                        return trans('translations.not-active');
                    }else{
                        return $row->getSrc()->agent->getProfileLink(User::AGENT);
                    }
                })
            ,
            (new FieldConfig)
                ->setName('code')
                ->setLabel('RECO.CODE')
                ->setSortable(false)
                ->setSorting(Grid::SORT_ASC)
                ->setCallback(function ($val, $row) {
                    return Format::recocode($val);
                })
            ,
            (new FieldConfig)
                ->setName('netto')
                ->setLabel('Warenkorb')
                ->setSortable(true)
                ->setSorting(Grid::SORT_ASC)
                ->setCallback(function ($val) {
                    if ($val == 0) {
                        return '';
                    }
                    return Format::currency($val);
                })
            ,
            (new FieldConfig)
                ->setName('discount_consumer')
                ->setLabel('Cashback')
                ->setSorting(Grid::SORT_ASC)
                ->setCallback(function ($val, $row) {
                    //return Format::currency($row->getSrc()->calculateConsumerDiscount(), true, false);
                    return $row->getSrc()->present()->discount_consumer;
                })
            ,
            (new FieldConfig)
                ->setName('provision_agent')
                ->setLabel('RECO.CASH')
                ->setSorting(Grid::SORT_ASC)
                ->setCallback(function ($val, $row) {
                    //return Format::currency($row->getSrc()->calculateAgentProvision(), true, false);
                    return $row->getSrc()->present()->provision_agent;
                })
            ,
            (new FieldConfig)
                ->setName('status_redeemed_at')
                ->setLabel('Eingelöst')
                ->setSortable(true)
                ->setSorting(Grid::SORT_ASC)
                ->setCallback(function ($val) {
                    return Format::date($val);
                })
            ,
            (new FieldConfig)
                ->setName('couponStatus')
                ->setLabel('Status')
                ->setSortable(true)
                ->setSorting(Grid::SORT_ASC)
                ->setCallback(function ($val, $row) {
                    return $row->getSrc()->getStatusText();
                })
            ,
            (new FieldConfig)
                ->setName('couponStatus')
                ->setLabel('Bezahlt')
                ->setCellHtmlAttributes(['class' => 'button-cell'])
                ->setSorting(Grid::SORT_ASC)
                ->setSortable(false)
                ->setCallback(function ($val, $row) {
                    if(in_array($val, Coupon::STATUS_GROUP_CAN_BE_MARKED_PAID)){
                        $row = $row->getSrc();
                        if(!$row->agent){
                            return "Empfehler nicht aktiv".'<br>'."Transaktion nicht möglich";
                        }
                        if(!$row->consumer){
                            return "Verbraucher nicht aktiv".'<br>'."Transaktion nicht möglich";
                        }
                        $coupon = Coupon::where('code', '=', $row->code)->first();
                        return '<a class="btn btn-green  confirm-payment-via-modal" id="c'
                            . $coupon->id
                            . '" data-confirm-href="' . route('coupon-paid', $coupon->id)
                            . '">Zahlung erhalten'
                            . '<span class="is-visible-in-responsive-table"></span></a>';
                    }
                    if($val == Coupon::STATUS_PAID){
                        $row = $row->getSrc();
                        $coupon = Coupon::find($row->id);
                        return '<span class="is-visible-in-responsive-table">bezahlt am</span> '
                            . Format::date($coupon->status_paid_at);
                    }
                })
        ];

        return $gridColumns;
    }
}