<?php

namespace App\Http\Grids\Seller;

use App\Coupon;
use App\Http\Grids\AbstractAccountGrid;
use App\Http\Grids\UserGrid;
use App\Invitation;
use App\Library\Facades\Format;
use App\Library\Grids\FieldConfig;
use App\Library\Grids\GridConfig;
use App\User;
use Illuminate\Support\Facades\Auth;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\FilterConfig;

class AgentGrid extends AbstractAgentGrid
{
    protected $_name = 'agents';

    protected function getGridQuery() {
        return Auth::user()->account->agentsWhereICanApplyToQuery();
    }

    protected function getGridColumns()
    {
        $gridColumns = parent::getGridColumns();

        $gridColumns['company']
            ->setLabel('Empfehler')
            ->setCallback(function ($val, $row) {
	            $account = $row->getSrc();
	            return $account->renderFullLink(User::AGENT);
            });

        unset($gridColumns['successRate']);
        unset($gridColumns['sharedCoupons']);
        unset($gridColumns['resolvedCoupons']);


        /*
        $gridColumns[] =
            (new FieldConfig)
                ->setName('account_id')
                ->setLabel('Chatten')
                ->setCellHtmlAttributes(['class' => 'chat-label'])
                ->setSortable(false)
                ->setCallback(function ($val, $row) {
                    if ($val !== null) { // nicht "ohne Anfrage verfügbar"
                        $agentId = User::where('account_id',$val)->first()->id;
                        return '<a href="javascript:;" onclick="jqac.arrowchat.chatWith('.$agentId.');"><img class="chat-image-small" src="/img/icons/chat-bubble.svg"> </a>';
                    }
                    return '';

                });
        */

        $gridColumns[] =
            (new FieldConfig)
                ->setName('account_id')
                ->setLabel(' ')
                ->setCellHtmlAttributes(['class' => 'button-cell'])
                ->setSortable(false)
                ->setCallback(function ($val, $row) {
                    $account = $row->getSrc();
                    $invitation = Invitation::where('account_id', '=', Auth::user()->account->id)->where('Invited_account_id', '=', $account->id)->first();
                    if($invitation['invited_account_id'] != $account->id) {
                        return '<a class="btn btn-white " href="' . route('agent-account-add', $account->id) . '">Anfragen</a>';
                    }
                    return 'angefragt ' . Format::date($invitation->created_at);
                });
        $gridColumns[] =
            (new FieldConfig)
                ->setName('account_id')
                ->setLabel(' ')
                ->setCellHtmlAttributes(['class' => 'button-cell'])
                ->setSortable(false)
                ->setCallback(function ($val,$row) {
                    $account = $row->getSrc();
                    $invitation = Invitation::where('account_id', '=', Auth::user()->account->id)->where('Invited_account_id', '=', $account->id)->first();
                    if($invitation['invited_account_id'] == $account->id) {
                        return '<a class="btn btn-white " class="" href="' . route('show-seller-account', $val) . '">' . '<i class="fa fa-user"></i></a>';
                    }
                });
        return $gridColumns;
    }
}