<?php


namespace App\Http\Grids\Seller;

use App\Http\Grids\AbstractAccountGrid;
use App\Library\Facades\Format;
use App\Library\Grids\DummyFieldConfig;
use App\Library\Grids\FieldConfig;
use App\Library\Grids\GlobalFilter;
use Illuminate\Support\Facades\DB;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\FilterConfig;

class AbstractAgentGrid extends AbstractAccountGrid
{

    public function getGlobalFiltersConfig()
    {

        $filters = [];

        $filters['fulltext']
            = new GlobalFilter($this->libraryAccountFullTextFilterConfig(), new DummyFieldConfig(), $this, 'fulltext');

        $filters['place'] = new GlobalFilter($this->libraryPlaceConfig(), new DummyFieldConfig(), $this, 'place');

        return $filters;
    }

    public function libraryAccountFullTextFilterConfig()
    {
        $config =
            (new FilterConfig)
                ->setLabel('Empfehler')
                ->setName('fulltext')
                ->setOperator(FilterConfig::OPERATOR_LIKE)
                ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                    $provider->getBuilder()
                        ->where(function ($query) use ($val) {
                            $query->where('accounts.company', 'like', '%' . $val . '%')
                                ->orWhere(DB::raw('CONCAT(users.firstname, " ", users.surname)'), 'like', '%' . $val . '%');
                        });
                });

        return $config;
    }

    protected function getGridColumns()
    {
        $gridColumns = parent::getGridColumns();
        unset($gridColumns['rating']);
        $gridColumns['successRate'] =
            (new FieldConfig)
                ->setName('conversation_rate')
                ->setLabel('Erfolgsrate')
                ->setSortable(false)
                ->setCallback(function ($val, $row) {
                    $account = $row->getSrc();
                    return Format::percent($account->getConversionRate());
                })
        ;

        $gridColumns['sharedCoupons'] =
            (new FieldConfig)
                ->setName('recommended')
                ->setLabel('Empfohlen')
                ->setSortable(false)
                ->setCallback(function ($val, $row) {
                    $account = $row->getSrc();
                    return $account->getSharedCouponCount();
                });
        $gridColumns['resolvedCoupons'] =
            (new FieldConfig)
                ->setName('redeemed')
                ->setLabel('Eingelöst')
                ->setSortable(false)
                ->setCallback(function ($val, $row) {
                    $account = $row->getSrc();
                    return $account->countRedeemedCoupons();
                });

        return $gridColumns;
    }


}