<?php

namespace App\Http\Grids\Recommend;

use App\Account;
use App\CouponTemplate;
use App\Library\Grids\FieldConfig;
use App\Library\Grids\GridConfig;
use App\LinkInvitations;
use App\Shortlink;
use App\Library\Grids\DefaultGrid;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\FilterConfig;

class AbstractRecommendationGrid extends DefaultGrid
{
    protected $userId;

    public function __construct($userId)
    {
        $this->userId = $userId;
        return parent::__construct($this->getGridConfig());
    }

    protected function getGridConfig()
    {
        return (new GridConfig)
            ->setDataProvider(
                new EloquentDataProvider($this->getGridQuery())
            )
            ->setName('meine-RECOMA-empfehlungen')
            ->setColumns($this->getGridColumns());
    }

    protected function getGridQuery()
    {
        $query = LinkInvitations::query()->where('inviting_user_id', '=', $this->userId);

        return $query;
    }

    protected function getGridColumns()
    {
        $gridColumns = [
            (new FieldConfig)
                ->setName('recommendation')
                ->setLabel('Empfehlung')
                ->setSortable(false)
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                )
                ->setCallback(function ($val, $row) {
                    $linkInvitation = $row->getSrc();
                    if ($linkInvitation->reason == 'recommend-recoma') {
                        return 'RECO.MA';
                    }
                    if($linkInvitation->reason == 'share-seller'){
                        $sellerAccount = Account::where('id', '=', $linkInvitation->shared_account_id)->first();
                        return $sellerAccount->company . ': zur Auswahl';
                    }
                    if($linkInvitation->reason == 'share-coupon'){
                        $couponTemplate = CouponTemplate::where('id', '=', $linkInvitation->coupon_template_id)->first();
                        //check if seller is noll from globalScope
                        if(!$couponTemplate->seller){
                            return trans('translations.not-active');
                        }else{
                            $sellerAccount = $couponTemplate->seller->account;
                            return $sellerAccount->company . ': ' . $couponTemplate->title;
                        }

                    }
                })
            ,
            (new FieldConfig)
                ->setName('recommendation_link')
                ->setLabel('Empfehlungslink')
                ->setSortable(false)
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                )
                ->setCallback(function ($val, $row) {
                    $linkInvitation = $row->getSrc();
                    $shortLink = Shortlink::where('link', 'like', '%' . $linkInvitation->token)->first();
                    return $shortLink ? $shortLink->getFullShortLink($shortLink, true) : '';
                })
            ,
            (new FieldConfig)
                ->setName('recommended_at')
                ->setLabel('Empfohlen am')
                ->setSortable(false)
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                )
                ->setCallback(function ($val, $row) {
                    $linkInvitation = $row->getSrc();
                    return $linkInvitation->created_at->format('d.m.Y H:i:s');
                })
        ];

        return $gridColumns;
    }
}