<?php

namespace App\Http\Grids\Operator;

use App\Library\Facades\Format;
use App\Library\Grids\FieldConfig;
use App\Library\Grids\GridConfig;
use App\Library\Grids\DefaultGrid;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\Grid;

class JobQueueGrid extends DefaultGrid
{
    public function __construct()
    {
        return parent::__construct($this->getGridConfig());
    }

    protected function getGridConfig()
    {
        $provider = new EloquentDataProvider($this->getGridQuery());

        return (new GridConfig)
            ->setDataProvider(
                $provider
            )
            ->setName('job-queue')
            ->setColumns($this->getGridColumns());
    }

    protected function getGridQuery()
    {
        $query = \App\Job::query();

        return $query;
    }

    protected function getGridColumns()
    {
        $gridColumns = [
            (new FieldConfig)
                ->setName('id')
                ->setLabel('ID')
            ,
            (new FieldConfig)
                ->setName('queue')
                ->setLabel('Queue')
                ->setSorting(Grid::SORT_ASC)
            ,
            (new FieldConfig)
                ->setName('payload')
                ->setLabel('Daten')
                ->setSorting(Grid::SORT_ASC)
                ->setCallback(function ($payload) {
                    $data = json_decode($payload);
                    return $data->job;
                })
            ,
            (new FieldConfig)
                ->setName('attempts')
                ->setLabel('Versuche')
                ->setSorting(Grid::SORT_ASC)
            ,
            (new FieldConfig)
                ->setName('available_at')
                ->setLabel('Aktiv seit')
                ->setSortable(false)
                ->setCallback(function ($val, $row) {
                        return Format::date($val);
                })
        ];

        return $gridColumns;
    }
}