<?php

namespace App\Http\Grids;

use App\Account;
use App\Library\Grids\FieldConfig;
use App\Library\Grids\GridConfig;
use App\User;
use Illuminate\Support\Facades\Auth;
use App\Library\Grids\DefaultGrid;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\FilterConfig;
use Nayjest\Grids\Grid;
use Nayjest\Grids\SelectFilterConfig;

class MemberGrid extends DefaultGrid
{
    public function __construct()
    {
        return parent::__construct($this->getGridConfig());
    }

    protected function getGridConfig()
    {
        return (new GridConfig)
            ->setDataProvider(
                new EloquentDataProvider($this->getGridQuery())
            )
            ->setName('Mitgliederverwaltung')
            ->setColumns($this->getGridColumns());
    }

    protected function getGridQuery() {
        $query = User::query()->where('account_id', '=' , Auth::user()->account_id);

        return $query;
    }

    protected function getGridColumns()
    {
        $gridColumns = [
            (new FieldConfig)
                ->setName('id')
                ->setLabel('ID')
                ->setSortable(true)
                ->setSorting(Grid::SORT_ASC)
            ,
            (new FieldConfig)
                ->setName('firstname')
                ->setLabel('Vorname')
                ->setSortable(true)
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                )
            ,
            (new FieldConfig)
                ->setName('surname')
                ->setLabel('Nachname')
                ->setSortable(true)
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                )
            ,
            (new FieldConfig)
                ->setName('email')
                ->setLabel('E-Mail')
                ->setSortable(true)
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                )
        ];


            $gridColumns[] = (new FieldConfig)
                ->setName('id')
                ->setLabel(' ')
                ->setSortable(false)
                ->setCellHtmlAttributes(['class' => 'button-cell'])
                ->setCallback(function ($val) {
                    return '<a class="btn btn-white " href=""><i class="fa fa-trash-o"></i></a>';
                });

        return $gridColumns;
    }
}