<?php

namespace App\Http\Grids\Fieldservice;

use App\Http\Grids\UserGrid as BaseUserGrid;
use App\User;
use Illuminate\Support\HtmlString;

class UserGrid extends BaseUserGrid
{
    protected $_name = 'useroverview';

    /**
     * Recuriter to filter by
     * @var User
     */
    protected $recruiter;


    /**
     * UserGrid constructor.
     *
     * @param User $recuriter Recruiter to filter by
     */
    public function __construct(User $recruiter) {
        $this->recruiter = $recruiter;
        parent::__construct();
    }

    protected function getGridQuery()
    {
        $query = parent::getGridQuery();
        $query->whereRecruiterUserId($this->getRecruiter()->id);
        return $query;
    }

    protected function getGridColumns()
    {
        $gridColumns = parent::getGridColumns();

        $gridColumns['actions']
            ->setCallback(function ($val, $row) {
                $user = $row->getSrc();
                if ($this->getRecruiter()->canEditUser($user)) {
                    return new HtmlString('<a class="btn btn-white " href="' . route( 'user-edit-id', $val ) . '"><i class="fa fa-pencil"></i></a>');
                } else {
                    return '(verifiziert)';
                }
            });

        return $gridColumns;
    }

    /**
     * @return mixed
     */
    public function getRecruiter() {
        return $this->recruiter;
    }


}