<?php

namespace App\Http\Grids\Consumer;

use App\Coupon;
use App\CouponTemplate;
use App\Library\Grids\FieldConfig;
use App\Library\Grids\GridConfig;
use App\User;
use App\Library\Grids\DefaultGrid;
use Illuminate\Support\Facades\Auth;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\FilterConfig;
use Nayjest\Grids\Grid;

class CouponViewGrid extends DefaultGrid
{
    public function __construct()
    {
        return parent::__construct($this->getGridConfig());
    }

    protected function getGridConfig()
    {
        return (new GridConfig)
            ->setDataProvider(
                new EloquentDataProvider($this->getGridQuery())
            )
            ->setName('RECO.BON Übersicht')
            ->setColumns($this->getGridColumns());
    }

    protected function getGridQuery()
    {
        return Coupon::query()
            ->where('consumer_user_id', '=', Auth::user()->id)
            ->where('status', '!=' , Coupon::STATUS_PENDING);
    }

    protected function getGridColumns()
    {
        $gridColumns = [
            (new FieldConfig)
                ->setName('title')
                ->setLabel('Titel')
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                )
        ];

        $gridColumns = array_merge($gridColumns, [
            (new FieldConfig)
                ->setName('coupon_template_id')
                ->setLabel('Dienstleister')
                ->setSorting(Grid::SORT_ASC)
                ->setCallback(function ($val) {
                    $couponTemplate = CouponTemplate::find($val);
                    return $couponTemplate->user->getDisplayName();
                })
            ,
            (new FieldConfig)
                ->setName('description')
                ->setLabel('RECO.BON Bedingung')
                ->setSorting(Grid::SORT_ASC)
            ,
            (new FieldConfig)
                ->setName('id')
                ->setLabel('Empfehler')
                ->setSorting(Grid::SORT_ASC)
                ->setCallback(function ($val, $row) {
                    return $row->getSrc()->agent->firstname . ' ' . $row->getSrc()->agent->surname;

                })
            ,
            (new FieldConfig)
                ->setName('discount_consumer')
                ->setLabel('Cashback in %')
                ->setSorting(Grid::SORT_ASC)
            ,
            (new FieldConfig)
                ->setName('code')
                ->setLabel('Code')
                ->setSortable(false)
                ->setSorting(Grid::SORT_ASC)
            ,
            (new FieldConfig)
                ->setName('netto')
                ->setLabel('Netto')
                ->setSortable(false)
                ->setSorting(Grid::SORT_ASC)

            ,
            (new FieldConfig)
                ->setName('status')
                ->setLabel('Status')
                ->setSortable(false)
                ->setSorting(Grid::SORT_ASC)
                ->setCallback(function ($val) {
                    return trans('translations.' . $val);
                })
            ,
            (new FieldConfig)
                ->setName('expiration_date')
                ->setLabel('Gültig bis')
            ,
            (new FieldConfig)
                ->setName('status')
                ->setLabel(' ')
                ->setCellHtmlAttributes(['class' => 'button-cell'])
                ->setSortable(false)
                ->setCallback(function ($val, $row) {
                    if ($val == 'redeemed') {
                        $coupon = $row->getSrc();

                        return '<a class="btn btn-white " href="' . route('coupon-assert-payment', $coupon['id']) . '">Auf Zahlung Hinweisen</a>';
                    }

                    return '';

                })
            ,
            (new FieldConfig)
                ->setName('id')
                ->setLabel('RECO.BON')
                ->setCellHtmlAttributes(['class' => 'button-cell'])
                ->setSortable(false)
                ->setCallback(function ($val, $row) {
                        $coupon = $row->getSrc();
                        return '<a class="btn btn-white " href="' . route('coupon-view', $coupon['id']) . '">RECO.BON Ansicht</a>';
                })
        ]);

        return $gridColumns;
    }
}