<?php

namespace App\Http\Grids;

use App\BankTransaction;
use App\Library\Facades\Format;
use App\Library\Grids\FieldConfig;
use Carbon\Carbon;
use App\Library\Grids\DefaultGrid;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\FilterConfig;

class BankTransactionGrid extends DefaultGrid
{
    protected $_name = 'banktransactions';

    protected function getGridQuery()
    {
        $query = BankTransaction::query();

        return $query;
    }

    protected function getGridColumns()
    {
        $gridColumns = [
            (new FieldConfig)
                ->setName('date')
                ->setLabel('Datum')
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                        ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                            $provider->getBuilder()
                                ->where('date', '=', Carbon::parse($val)->format('Y-m-d'));
                        })
                )
                ->setCallback(function ($val, $row) {
                    return Format::date($row->getSrc()->date);
                })
            ,            (new FieldConfig)
                ->setName('valuta')
                ->setSortable(false)
                ->setLabel('Valuta')
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                        ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                            $provider->getBuilder()
                                ->where('date', '=', Carbon::parse($val)->format('Y-m-d'));
                        })
                )
                ->setCallback(function ($val, $row) {
                    return Format::date($row->getSrc()->valuta_date);
                })
            ,
            (new FieldConfig)
                ->setName('remote_bank_code')
                ->setLabel('Gegenkonto - Bank')
                ->setSortable(true)
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                )
            ,
            (new FieldConfig)
                ->setName('remote_account_holder_name')
                ->setLabel('Kontoinhaber')
                ->setSortable(true)
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                )
                ->setCallback(function ($val, $row) {
                    return str_replace('|', '', e($val));
                })
            ,
            (new FieldConfig)
                ->setName('amount')
                ->setLabel('Betrag')
                ->setSortable(true)
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                )
                ->setCallback(function ($val, $row) {
                    return Format::currency($val);
                })
            ,
            (new FieldConfig)
                ->setName('purpose')
                ->setLabel('Verwendungszweck')
                ->setSortable(true)
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                )
                ->setCallback(function ($val, $row) {
                    return str_replace('|', ' ', e($val));
                })
            ,
            (new FieldConfig)
                ->setName('receipt')
                ->setLabel('Zugeordneter Beleg')
                ->setSortable(true)
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                )
                ->setCallback(function ($val, $row) {
                    if ($receipt = $row->getSrc()->getReceipt()) {
                        return $receipt->number;
                    }else{
                        return '<a class="btn btn-primary" href='
                            . route('set-bank_transaction-status', $row->getSrc()->id)
                            . '>Zuordnen<span class="is-visible-in-responsive-table"></span></a>';
                    }
                })
            ,
        ];

        return $gridColumns;
    }
}