<?php

namespace App\Http\Grids\Agent;

use App\Http\Grids\AbstractAccountGrid;
use App\Invitation;
use App\Library\Facades\Format;
use App\Library\Grids\FieldConfig;
use App\Library\Grids\GridConfig;
use Illuminate\Support\Facades\Auth;
use Nayjest\Grids\EloquentDataProvider;
use App\User;

class SellerGrid extends AbstractAccountGrid
{
    protected $_name = 'Seller';

    protected function getGridQuery()
    {
        return Auth::user()->account->sellersWhereICanApplyToQuery();
    }

    protected function getGridColumns()
    {
        $gridColumns = parent::getGridColumns();

        /*
        $gridColumns[] =
            (new FieldConfig)
                ->setName('id')
                ->setLabel('Chatten ')
                ->setCellHtmlAttributes(['class' => 'button-cell'])
                ->setSortable(false)
                ->setCallback(function ($val, $row) {
                    if ($val !== null) { // nicht "ohne Anfrage verfügbar"
                        $sellerId = User::where('account_id',$val)->first()->id;
                        return '<a href="javascript:;" onclick="jqac.arrowchat.chatWith('.$sellerId.');"><img class="chat-image-small" src="/img/icons/chat-bubble.svg"> </a>';
                    }
                    return '';

                });
        */


        $gridColumns[] =
            (new FieldConfig)
                ->setName('id')
                ->setLabel('Merken')
                ->setSortable(false)
                ->setCellHtmlAttributes(['class' => 'button-cell'])
                ->setCallback(function ($val, $row) {
                    $account = $row->getSrc();
                    $invitation = Invitation::findByAccounts(Auth::user()->account, $account);

                    if ($account->all_connections == 1) {
                        return '<a class="btn btn-white btn-white full-width" href="' . route('seller-account-add', $account->id) . '"><i class="fa fa-star"></i> <span class="visible-sm-inline visible-md-inline visible-lg-inline">Merken</span></a>';
                    }

                    if ($invitation['invited_account_id'] != $account->id) {
                        return '<a class="btn btn-white full-width" href="' . route('seller-account-add', $account->id) . '"><i class="fa fa-envelope-o"></i> <span class="visible-sm-inline visible-md-inline visible-lg-inline">Anfragen</span></a>';
                    }

                    return 'angefragt ' . Format::date($invitation->created_at);
                });

        $gridColumns[] =
            (new FieldConfig)
                ->setName('id')
                ->setLabel(' ')
                ->setSortable(false)
                ->setCellHtmlAttributes(['class' => 'button-cell'])
                ->setCallback(function ($val, $row) {
                    $account = $row->getSrc();
                    $couponTemplates = $account->couponTemplates;
                    $hasValidTemplates = false;
                    $invitation = Invitation::findByAccounts(Auth::user()->account, $account);

                    $link = 'Keine RECO.BONS vorhanden';
                    if ($account->all_connections == 1) {
                        if (count($account->couponTemplates) > 0) {
                            foreach ($couponTemplates as $template) {
                                if (!$template->isExpired()) {
                                    $hasValidTemplates = true;
                                }
                            }
                            if ($hasValidTemplates) {
                                $link = '<a class="btn btn-primary-cta btn-send full-width" href="' . url('/share-seller') . '/' . $row->getSrc()->id . '">Empfehlen</a> ';
                            }
                        }
                    }
                    return $link;
                });


        return $gridColumns;
    }
}