<?php

namespace App\Http\Grids\Agent;

use App\Http\Grids\AbstractAccountGrid;
use App\Library\Grids\FieldConfig;
use App\Library\Grids\GridConfig;
use Illuminate\Support\Facades\Auth;
use Nayjest\Grids\EloquentDataProvider;
use App\User;

class MySellerGrid extends AbstractAccountGrid
{
    protected $_name = 'MySeller';

    protected function getGridQuery()
    {
        return Auth::user()->account->availableSellerAccountsQuery();
    }

    protected function getGridColumns()
    {
        $gridColumns = parent::getGridColumns();

        /*
        $gridColumns[] =
            (new FieldConfig)
                ->setName('related_account_id')
                ->setLabel('Chatten')
                ->setCellHtmlAttributes(['class' => 'button-cell'])
                ->setSortable(false)
                ->setCallback(function ($val, $row) {
                    if ($val !== null) { // nicht "ohne Anfrage verfügbar"
                        $sellerId = User::where('account_id',$val)->first()->id;
                        return '<a href="javascript:;" onclick="jqac.arrowchat.chatWith('.$sellerId.');"><img class="chat-image-small" src="/img/icons/chat-bubble.svg"> </a>';
                    }
                    return '';

                });
        */

        $gridColumns[] =
            (new FieldConfig)
                ->setName('related_account_id')
                ->setLabel(' ')
                ->setCellHtmlAttributes(['class' => 'button-cell'])
                ->setSortable(false)
                ->setCallback(function ($val, $row) {
                    if ($val !== null) { // nicht "ohne Anfrage verfügbar"
                        return '<a class="btn btn-white delete-via-modal" data-delete-href="' . route('seller-account-remove', $val) . '"><i class="fa fa-trash-o"></i> <span class="visible-sm-inline visible-md-inline visible-lg-inline">Entfernen</span></a> ';
                    }
                    return '';

                });
        $gridColumns[] =
            (new FieldConfig)
                ->setName('related_account_id')
                ->setLabel(' ')
                ->setCellHtmlAttributes(['class' => 'button-cell'])
                ->setSortable(false)
                ->setCallback(function ($val, $row) {
                    $account = $row->getSrc();
                    $couponTemplates = $account->couponTemplates;
                    $hasValidTemplates = false;
                    $links = 'Keine RECO.BONS vorhanden';
                    if (count($couponTemplates) > 0) {
                        foreach ($couponTemplates as $template) {
                            if (!$template->isExpired()) {
                                $hasValidTemplates = true;
                            }
                        }
                        if ($hasValidTemplates) {
                            $links = '<a class="btn btn-primary-cta btn-send" href="' . url('/share-seller') . '/' . $account->id . '">Empfehlen</a> ';
                        }
                    }
                    return $links;
                });


        return $gridColumns;
    }
}