<?php

namespace App\Http\Grids\Agent;

use App\Coupon;
use App\CouponTemplate;
use App\Library\Facades\Format;
use App\Library\Grids\DefaultGrid;
use App\Library\Grids\FieldConfig;
use App\Library\Grids\GridConfig;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\HtmlString;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\FilterConfig;
use Nayjest\Grids\Grid;

class AgentMultiCouponGrid extends DefaultGrid
{
    protected $_name = 'recobons';

    protected function getGridQuery()
    {
        return Coupon::whereAgentUserId(Auth::user()->id)
            ->select([
                'coupons.*',
                User::getDisplayNameDBExpression('consumer_display_name', 'consumers'),
                User::getDisplayNameDBExpression('seller_display_name', 'sellers'),
                'coupon_templates.user_id as coupon_template_user_id',
                'seller_accounts.company as seller_company',
                'seller_accounts.id as seller_account_id',
            ])
            ->join('users as consumers', 'consumer_user_id', '=', 'consumers.id')
            ->join('coupon_templates', 'coupon_template_id', '=', 'coupon_templates.id')
            ->join('users as sellers', 'coupon_templates.user_id', '=', 'sellers.id')
            ->join('accounts as seller_accounts', 'sellers.account_id', '=', 'seller_accounts.id')
            ->where('selection', '=', 1)
            ->groupBy('selection_group');
    }

    protected function getGridColumns()
    {
        $gridColumns = [
            (new FieldConfig)
                ->setName('seller_company')
                ->setLabel('Dienstleister')
                ->setSorting(Grid::SORT_ASC)
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                        ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                            $provider->getBuilder()
                                ->where(User::getDisplayNameDBExpression(false, 'sellers'), 'like', '%' . $val . '%');

                        })
                )
                ->setCallback(function ($val, $row) {
                    if(!$row->getSrc()->template->seller){
                        return trans('translations.not-active');
                    }
                    if ($val == '') {
                        $val = $row->getSrc()->seller_display_name;
                    }
                    return new HTMLString('<a href="' . route('show-seller-account', $row->getSrc()->seller_account_id) . '">' . e($val) . '</a>');
                })
            ,
            (new FieldConfig)
                ->setName('consumer_display_name')
                ->setLabel('Verbraucher')
                ->setSorting(Grid::SORT_ASC)
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                        ->setFilteringFunc(function ($val, EloquentDataProvider $provider) {
                            $provider->getBuilder()
                                ->where(User::getDisplayNameDBExpression(false, 'consumers'), 'like', '%' . $val . '%');

                        })
                )
                ->setCallback(function ($val, $row) {
                    if(!$row->getSrc()->consumer){
                        return trans('translations.not-active');
                    }else{
                        return $row->getSrc()->consumer->getProfileLink(User::CONSUMER);
                    }
                })
            ,
            (new FieldConfig)
                ->setName('created_at')
                ->setLabel('Empfohlen')
                ->setSorting(Grid::SORT_ASC)
                ->setCallback(function ($val) {
                    return Format::date($val);
                })
        ];

        return $gridColumns;
    }
}