<?php

namespace App\Http\Grids;

use App\Library\Grids\FieldConfig;
use App\Library\Grids\GridConfig;
use App\User;
use App\Library\Grids\DefaultGrid;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\FilterConfig;

class AccountGrid extends DefaultGrid
{
    protected $accountId;

    public function __construct($accountId)
    {
        $this->accountId = $accountId;
        return parent::__construct($this->getGridConfig());
    }

    protected function getGridConfig()
    {
        return (new GridConfig)
            ->setDataProvider(
                new EloquentDataProvider($this->getGridQuery())
            )
            ->setName('Mitgliederverwaltung')
            ->setColumns($this->getGridColumns());
    }

    protected function getGridQuery() {
        $query = User::query()->where('account_id', '=' , $this->accountId);

        return $query;
    }

    protected function getGridColumns()
    {
        $gridColumns = [
            (new FieldConfig)
                ->setName('firstname')
                ->setLabel('Vorname')
                ->setSortable(true)
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                )
            ,
            (new FieldConfig)
                ->setName('surname')
                ->setLabel('Nachname')
                ->setSortable(true)
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                )
            ,
            (new FieldConfig)
                ->setName('email')
                ->setLabel('E-Mail')
                ->setSortable(true)
                ->addFilter(
                    (new FilterConfig)
                        ->setOperator(FilterConfig::OPERATOR_LIKE)
                )
        ];

        return $gridColumns;
    }
}