<?php

namespace App\Http\Controllers;

use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\View;

class WidgetController extends Controller
{
    /**
     * Method to show widget list.
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $user = Auth::user();

        $seller = $this->getSeller();

        $deals = $seller->getAvailableCouponTemplates();

        $widgetInviteCode = htmlentities(
            '<script async src="' . str_replace('http://', 'https://', route('widget-invite', ['alias' => $seller->alias])) . '"></script>'
        );

        $widgetDealsCode = htmlentities(
            '<script async src="' . str_replace('http://', 'https://', route('widget-deals',  ['alias' => $seller->alias])) . '"></script>'
        );

        return view('redesign.back.metronic.widgets.index', [
            'widgetInviteCode' => $widgetInviteCode,
            'widgetDealsCode'  => $widgetDealsCode,
            'deals'            => $deals,
            'options'          => $seller->options->keyBy('key'),
            'user'             => $user,
        ]);
    }

    /**
     * Method to return js-code which builds deals widget.
     *
     * @param $alias
     * @return mixed
     */
    public function deals($alias)
    {
        $seller = User::where('alias', $alias)->first();
        $deals  = $seller->getAvailableCouponTemplates();

        if ( $seller && $deals->count() ) {
            $contents = View::make('widgets.scripts.deals')->with([
                'seller'  => $seller,
                'deals'   => $deals,
                'options' => $seller->options->keyBy('key'),
            ]);
            $response = Response::make($contents);
            $response->header('Content-Type', 'application/javascript');
            return $response;
        }
    }

    /**
     * Method to return js-code which builds invite widget.
     *
     * @param $alias
     * @return mixed
     */
    public function invite($alias)
    {
        $seller = User::where('alias', $alias)->first();

        if ($seller) {
            $contents = View::make('widgets.scripts.invite')->with('seller', $seller);
            $response = Response::make($contents);
            $response->header('Content-Type', 'application/javascript');
            return $response;
        }
    }

    /**
     * Method to return js-code which builds special WERU widget.
     *
     * @return mixed
     */
    public function weru()
    {
        $contents = View::make('widgets.scripts.weru');
        $response = Response::make($contents);
        $response->header('Content-Type', 'application/javascript');
        return $response;
    }

    /**
     * Method to return active deals widget.
     *
     * @param $alias
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function dealsEmbed($alias)
    {
        app('debugbar')->disable(); // for local testing

        $seller = User::where('alias', $alias)->first();
        $deals = $seller->getAvailableCouponTemplates();

        if ( $seller && $deals->count() ) {
            return view('widgets.embed.deals.index', [
                'deals'    => $deals,
                'seller'   => $seller,
                'options'  => $seller->options->keyBy('key'),
            ]);
        }
    }

    /**
     * Method for return invitation widget.
     *
     * @param $alias
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function inviteEmbed($alias)
    {
        app('debugbar')->disable(); // for local testing

        $seller = User::where('alias', $alias)->first();

        if ( $seller && $seller->getAvailableCouponTemplates()->count() ) {
            return view('widgets.embed.invite.index', [
                'deal'     => $seller->getInviteWidgetDeal(),
                'seller'   => $seller,
                'options'  => $seller->options->keyBy('key'),
            ]);
        }
    }

    /**
     * Method to return special WERU widget.
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function weruEmbed()
    {
        app('debugbar')->disable(); // for local testing

        return view('widgets.embed.weru.index');
    }

    /**
     * Metod to show deals widget preview page.
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function dealsPreview()
    {
        return view('redesign.back.metronic.widgets.deals_preview');
    }

    /**
     * Method to show invite widget preview page.
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function invitePreview()
    {
        return view('redesign.back.metronic.widgets.invite_preview');
    }
}