<?php

namespace App\Http\Controllers;

use App\Services\UsersGiftService;
use App\UsersGift;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use App\Http\Requests\UsersGiftRequest;

class UsersGiftController extends Controller
{
    /**
     * Method to show users gifts list.
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        return view('usersgifts.index', [
            'usersGifts' => UsersGift::all(),
        ]);
    }

    /**
     * Method to show gifts of concrete user.
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function own()
    {
        $usersGifts = UsersGift::with(['gift', 'coupon'])
            ->where('user_id', Auth::id())
            ->get();

        return view('redesign.front.user.gifts', [
            'usersGifts' => $usersGifts,
        ]);
    }

    /**
     * Method to show edit form.
     *
     * @param UsersGift $usersGift
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit(UsersGift $usersGift)
    {
        $user = Auth::user();

        if ( $user->id !== $usersGift->user_id || !$usersGift->isEditableByOwner() ) {
            return Redirect::to(route('owngift-list'))->with('notification', array(
                'type'        => 'error',
                'title'       => 'Fehler',
                'description' => 'Eingeschränkter Zugang.'
            ));
        }

        return view('owngifts.edit', [
            'user'      => $user,
            'usersGift' => $usersGift,
        ]);
    }

    /**
     * Method to update users gift.
     *
     * @param UsersGiftRequest $request
     * @param UsersGift $usersGift
     * @return mixed
     */
    public function update(UsersGiftRequest $request, UsersGift $usersGift)
    {
        (new UsersGiftService($usersGift))->setAddress($request->getAll());

        return Redirect::to(route('owngift-list'))->with('notification', array(
            'type'        => 'success',
            'title'       => 'Erfolg',
            'description' => ''
        ));
    }

    /**
     * Method to set status STATUS_SENT.
     *
     * @param UsersGift $usersGift
     * @return mixed
     */
    public function markAsSent(UsersGift $usersGift)
    {
        if ( !$usersGift->isReady() ) {
            return Redirect::to(route('usersgift-list'))->with('notification', array(
                'type'        => 'error',
                'title'       => 'Fehler',
                'description' => 'Eingeschränkter Zugang.'
            ));
        }

        $usersGift->status = UsersGift::STATUS_SENT;

        $usersGift->save();

        return Redirect::to(route('usersgift-list'))->with('notification', array(
            'type'        => 'success',
            'title'       => 'Erfolg',
            'description' => ''
        ));
    }

    /**
     * Method to set status STATUS_RECEIVED.
     *
     * @param UsersGift $usersGift
     * @return mixed
     */
    public function markAsReceived(UsersGift $usersGift)
    {
        $user = Auth::user();

        if ( $user->id !== $usersGift->user_id || !$usersGift->isSent() ) {
            return Redirect::to(route('owngift-list'))->with('notification', array(
                'type'        => 'error',
                'title'       => 'Fehler',
                'description' => 'Eingeschränkter Zugang.'
            ));
        }

        $usersGift->status = UsersGift::STATUS_RECEIVED;

        $usersGift->save();

        return Redirect::to(route('owngift-list'))->with('notification', array(
            'type'        => 'success',
            'title'       => 'Erfolg',
            'description' => ''
        ));
    }
}
