<?php

namespace App\Http\Controllers;


use App\Http\Requests\TFATokenRequest;
use App\Services\DeviceService;
use App\Services\RouteService;
use App\Services\TFAService;
use Illuminate\Support\Facades\Auth;

class TFAController extends Controller
{
    /**
     * Method to show TFA form.
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $user = Auth::user();

        if ( !(new TFAService($user))->needTwoFactorAuth() ) {
            return redirect(route('home'));
        }

        return view('redesign.auth.tfa.index');
    }

    /**
     * Method to verify TFA token and redirect.
     *
     * @param TFATokenRequest $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function verify(TFATokenRequest $request)
    {
        $user = Auth::user();

        $tfaService = new TFAService($user);

        if ( $tfaService->isTokenExpired() ) {
            Auth::logout();

            return redirect()
                ->to(url('/login'))
                ->with('notification', $this->_e('Der Zwei-Faktor-Code ist abgelaufen. Bitte melde Dich erneut an.'));
        }

        $tfaService->reset();

        (new DeviceService())->trust($user);

        return redirect(route('home'));
    }

    /**
     * Method to redirect user to profile with success message.
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function googleConnect()
    {
        $user = Auth::user();

        return redirect()
            ->to( (new RouteService($user))->getProfileRoute() . '#security' )
            ->with('notification', $this->_s('Die Zwei-Faktor-Authentifizierung wurde erfolgreich aktiviert'));
    }

    /**
     * Method to disconnect Google TFA.
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function googleDisconnect()
    {
        $user = Auth::user();

        (new TFAService($user))->googleDisconnect();

        return redirect()
            ->to( (new RouteService($user))->getProfileRoute() . '#security' )
            ->with('notification', $this->_s('Du hast die Verbindung mit Zwei-Faktor-Authentifizierung erfolgreich getrennt'));
    }
}