<?php

namespace App\Http\Controllers;

use App\CouponTemplate;
use App\Services\SearchService;
use Illuminate\Http\Request;

class SearchController extends Controller
{
    /**
     * Method to get search results.
     *
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
        $q = $request->get('q');

        if (!$q) {
            return redirect()->to(route('deals.index'));
        }

        $deals = (new SearchService($q, 0, false))->findDeals();

        $top = $deals->count()
            ? collect([])
            : CouponTemplate::available()->top()->limit(10)->get();

        return view('redesign.front.search.index', [
            'deals' => $deals,
            'top'   => $top,
        ]);
    }
}
