<?php

namespace App\Http\Controllers;

use App\Account;
use App\CouponTemplate;
use App\Http\Grids\Recommend\RecommendCouponGrid;
use App\Http\Grids\Recommend\RecommendRecomaGrid;
use App\Http\Grids\Recommend\RecommendSellerGrid;
use hisorange\BrowserDetect\Facade\Parser as BrowserDetect;

use Illuminate\Support\Facades\Auth;

class RecommendationController extends Controller
{
    public function index()
    {
        return view('recommendation/index', [

        ]);
    }

    public function recommendRecoma()
    {

        $buttons = [
            [
                'name' => 'Whatsapp',
                'url' => route('linkinvitation', ['reason' => 'recommend-recoma', 'type' => 'whatsapp']),
                'target' => true,
            ],
            [
                'name' => 'E-Mail',
                'url' => route('linkinvitation', ['reason' => 'recommend-recoma', 'type' => 'email']),
            ],
            [
                'name' => 'SMS',
                'url' => route('linkinvitation', ['reason' => 'recommend-recoma', 'type' => 'sms']),
            ]
        ];
        $isMobile = BrowserDetect::isMobile();
        $grid = new RecommendRecomaGrid(Auth::user()->id);
        return view('recommendation/recommend-recoma')
            ->with(compact('buttons', 'grid'), $isMobile);
    }

    /**
     * @param $account Account
     * @return $this
     */
    public function shareSeller($account)
    {
        $buttons = [
            [
                'name' => 'Whatsapp',
                'url' => route('linkinvitation', ['reason' => 'share-seller', 'id' => $account->id, 'type' => 'whatsapp']),
                'target' => true,
            ],
            [
                'name' => 'E-Mail',
                'url' => route('linkinvitation', ['reason' => 'share-seller', 'id' => $account->id, 'type' => 'email']),
            ],
            [
                'name' => 'SMS',
                'url' => route('linkinvitation', ['reason' => 'share-seller', 'id' => $account->id, 'type' => 'sms']),
            ]
        ];

        $grid = new RecommendSellerGrid(Auth::user()->id);
        $isMobile = BrowserDetect::isMobile();
        return view('recommendation.recommend-coupon-or-seller')
            ->with(compact('buttons', 'account','grid'), $isMobile);

    }

    /**
     * @param $couponTemplate CouponTemplate
     * @return $this
     */
    public function shareCoupon($couponTemplate)
    {

        $account = $couponTemplate->user->account;

        $buttons = [
            [
                'name' => 'Whatsapp',
                'url' => route('linkinvitation', ['reason' => 'share-coupon', 'id' => $couponTemplate->id, 'type' => 'whatsapp']),
                'target' => true,
            ],
            [
                'name' => 'E-Mail',
                'url' => route('linkinvitation', ['reason' => 'share-coupon', 'id' => $couponTemplate->id, 'type' => 'email']),
            ],
            [
                'name' => 'SMS',
                'url' => route('linkinvitation', ['reason' => 'share-coupon', 'id' => $couponTemplate->id, 'type' => 'sms']),
            ]
        ];
        $isMobile = BrowserDetect::isMobile();
        $grid = new RecommendCouponGrid(Auth::user()->id);
        return view('recommendation.recommend-coupon-or-seller')
            ->with(compact('buttons', 'grid', 'account','couponTemplate'), $isMobile);
    }

    public function inviteNewAgent()
    {
        $buttons = [
            [
                'name' => 'Whatsapp',
                'url' => route('linkinvitation', ['reason' => 'invite-new-agent', 'type' => 'whatsapp']),
                'target' => true,
            ],
            [
                'name' => 'E-Mail',
                'url' => route('linkinvitation', ['reason' => 'invite-new-agent', 'type' => 'email']),
            ],
            [
                'name' => 'SMS',
                'url' => route('linkinvitation', ['reason' => 'invite-new-agent', 'type' => 'sms']),
            ],
            [
                'name' => 'Masseneinladung',
                'url' => route('massinvitation'),
            ]
        ];
        $isMobile = BrowserDetect::isMobile();
        return view('recommendation/recommend-recoma')
            ->with(compact('buttons'), $isMobile);
    }

}
