<?php

namespace App\Http\Controllers;

use App\Services\PayPalService;

class PayPalController extends Controller
{
    /**
     * Method to connect PayPal account.
     *
     * @return \Illuminate\Http\RedirectResponse
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function connect()
    {
        $code = request()->get('code');

        $redirect = session('paypal_redirect', route('user.profile') . '#payment');

        $paypalConnection = (new PayPalService())->connect($code);

        if ($paypalConnection) {
            return redirect()->to($redirect);
        } else {
            return redirect()
                ->to($redirect)
                ->with('paypal', 'Ein Fehler ist aufgetreten. Versuchen Sie es nochmal');
        }
    }

    /**
     * Method to disconnect PayPal account.
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function disconnect()
    {
        (new PayPalService())->disconnect();

        return redirect()->to(route('user.profile') . '#payment');
    }
}
