<?php

namespace App\Http\Controllers;

use App\Options;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\InviteOptionsRequest;
use App\Http\Requests\GlobalOptionsRequest;
use Illuminate\Support\Facades\Redirect;

class OptionsController extends Controller
{
    /**
     * Method to save global widget options.
     *
     * @param GlobalOptionsRequest $request
     * @return mixed
     */
    public function saveGlobalWidgetOptions(GlobalOptionsRequest $request)
    {
        $user   = Auth::user();
        $seller = $this->getSeller();

        $options = $seller->options->keyBy('key');

        Options::updateOrCreate([
            'user_id' => $seller->id,
            'key'     => 'widgets.colors.main_bg',
        ], [
            'value'   => $request->get('main_bg'),
        ]);

        Options::updateOrCreate([
            'user_id' => $seller->id,
            'key'     => 'widgets.colors.main_txt',
        ], [
            'value'   => $request->get('main_txt'),
        ]);

        Options::updateOrCreate([
            'user_id' => $seller->id,
            'key'     => 'widgets.colors.main_bg_h',
        ], [
            'value'   => $request->get('main_bg_h'),
        ]);

        Options::updateOrCreate([
            'user_id' => $seller->id,
            'key'     => 'widgets.colors.main_txt_h',
        ], [
            'value'   => $request->get('main_txt_h'),
        ]);

        activity($user)->register('widget colors edited', [
            'main_bg'    => $options['widgets.colors.main_bg']->value ?? null,
            'main_txt'   => $options['widgets.colors.main_txt']->value ?? null,
            'main_bg_h'  => $options['widgets.colors.main_bg_h']->value ?? null,
            'main_txt_h' => $options['widgets.colors.main_txt_h']->value ?? null,
        ], [
            'main_bg'    => $request->get('main_bg'),
            'main_txt'   => $request->get('main_txt'),
            'main_bg_h'  => $request->get('main_bg_h'),
            'main_txt_h' => $request->get('main_txt_h'),
        ]);

        return Redirect::to(route('seller.widgets.index'))->with('notification', $this->_s('Erfolgreich gespeichert'));
    }

    /**
     * Method to save invite widget options.
     *
     * @param InviteOptionsRequest $request
     * @return mixed
     */
    public function saveInviteWidgetOptions(InviteOptionsRequest $request)
    {
        $user   = Auth::user();
        $seller = $this->getSeller();

        $options = $seller->options->keyBy('key');

        Options::updateOrCreate([
            'user_id' => $seller->id,
            'key'     => 'invite.deal_id',
        ], [
            'value'   => $request->get('deal'),
        ]);

        activity($user)->register('invite widget edited', [
            'deal_id' => $options['invite.deal_id']->value ?? null,
        ], [
            'deal_id' => $request->get('deal'),
        ]);

        return Redirect::to(route('seller.widgets.index'))->with('notification', $this->_s('Erfolgreich gespeichert'));
    }
}
