<?php

namespace App\Http\Controllers\Onboarding;

use App\Gift;
use App\CouponTemplate;
use App\Http\Controllers\UserController;
use App\Http\Requests\OverlaySellerInviteAgentsRequest;
use App\Http\Requests\OverlaySellerRequestCompany;
use App\Http\Requests\OverlaySellerRequestPayment;
use App\Presenters\CouponTemplatePresenter;
use App\Services\SellerRegistrationService;
use App\User;
use Auth;
use File;
use Image;
use Newsletter;
use App\Http\Controllers\Controller;
use App\Category;

class OnboardingSellerController extends Controller
{

    const MAX_LEVEL = 6;

    public function index(){
        $account = auth::user()->account;

        if (request('increase') == 1) {
            $account->onboarding_process_level ++;
            $account->save();
            return redirect('/onboarding-seller');
        }
        switch((int)$account->onboarding_process_level){
            case 0:
                return view('onboarding.seller.welcome');
            break;
            case 1:
                return view('onboarding.seller.invite_agents');
            break;
            case 2:
                $couponTemplate = new CouponTemplate();
                return view('onboarding.seller.create_coupons',[
                    'categories'     => Category::all(),
                    'couponTemplate' => $couponTemplate,
                    'typeIcons'      => CouponTemplatePresenter::$typeIcons,
                    'typeNames'      => CouponTemplatePresenter::$typeNames,
                    'gifts'          => Gift::available(),
                ]);
            break;
            case 3:
                if(auth::user()->completedProfile()){
                    return view("onboarding.seller.set_profile_data_not_set_by_ADM");
                }else{
                    return view('onboarding.seller.complete_profile_company_data');
                }
            break;
            case 4:
                return view('onboarding.seller.complete_profile_payment_data');
            break;
            case 5:
                return view('onboarding.seller.complete_tour');
            break;
            default:
                return redirect("/dashboard/seller");
        }
    }

    public function inviteAgents(OverlaySellerInviteAgentsRequest $requestInvitations){
        $account = auth::user()->account;
        $agentInvited=false;
        $emails = $requestInvitations->only('invitedAgentEmail');

        foreach($emails['invitedAgentEmail'] as $email){
            if($email!=""){
                $token=Controller::link('invite-new-agent', 'email', null, '1');
                UserController::sendAgentInvitationFromOverlay($token,$email);
                $agentInvited=true;
            }
        }
        $account->onboarding_process_level ++;
        $account->save();

        if($agentInvited==true){
            return redirect('/onboarding-seller/')
                ->with('notification', $this->notificationSuccess('Einladung erfolgreich versendet.'));
        }
        return redirect('/onboarding-seller/');
    }



    /**
     * @param $newData
     * @return \Illuminate\Http\RedirectResponse
     */
    public function updateSellerCompanyOverlay(OverlaySellerRequestCompany $requestCompany)
    {
        $user = Auth::user();
        $account=$user->account;
        if($requestCompany->file('upload_portrait')){

            //FIXME:use setLogo() from UserController to set logo

            // remove file if already exist
            if($account->upload_portrait){
                File::delete(storage_path('app/portraits/').$account->upload_portrait);
            }

            $name = preg_replace('/[^[:alnum:].]/', '', $requestCompany
                ->file('upload_portrait')
                ->getClientOriginalName());

            $logoName = $account->id .'_logo_'. $name;

            $account->update([
                "upload_portrait"=>$logoName,
            ]);

            $requestCompany
                ->file('upload_portrait')
                ->move(storage_path('app/portraits'), $logoName);

            $logoImage = Image::make(storage_path('app/portraits/') . $logoName);

            $width = $logoImage->width() < $logoImage->height() ? null : 200;
            $height = $logoImage->width() < $logoImage->height() ? 200 : null;
            $logoImage->resize($width, $height, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            });
            $logoImage->save();
        }

        $account->update($requestCompany->except('upload_portrait','phone'));
        $user->update([
            'phone' => $requestCompany->get('phone')
        ]);


        if( $requestCompany->get('newsletter')){
            Newsletter::subscribe($user->email);
        }
        $account->onboarding_process_level ++;
        $account->save();

        return redirect('onboarding-seller')
            ->with('notification', $this->notificationSuccess('Profildaten erfolgreich gespeichert.'));
    }

    /**
     * @param UserRequest $request
     * @param User $user
     */
    public function updateSellerPaymentOverlay(OverlaySellerRequestPayment $request)
    {

        $user = \auth()->user();
        $account = $user->account;
        $account->update([
            'payment' => $request->get('payment'),
            'iban_owner' => $request->get('iban_owner'),
            'iban' => $request->get('iban'),
            'tax_id' => $request->get('tax_id'),
        ]);

        $account->createMembershipInvoice();

        $user->assignRole('seller');
        $user->assignRole('seller-active');
        if($user->account->couponTemplates()->first()!=null){
            $user->account->couponTemplates()->first()->update([
                'status' => 'active'
            ]);
        }
        $user->account->createSepaMandat();
        SellerRegistrationService::applyInvitationBonus($user->account);

        $account->onboarding_process_level ++;
        $account->status = \App\User::STATUS_ACTIVE;
        $account->save();

        $user->update(['status'=>User::STATUS_ACTIVE]);
        $account->syncReceivedSellerRoleAt();
        return redirect('onboarding-seller')
            ->with('notification', $this->notificationSuccess('Bankdaten erfolgreich gespeichert.'));
    }


    public function updateDataFromSellerCreatedByAdmOrOperator()
    {

        $this->validate(request(), [
            'all_connections' => 'required'
        ]);

        $user = Auth::user();
        $account=$user->account;

        if(request()->file('upload_portrait')){

            // remove file if already exist
            if($account->upload_portrait){
                File::delete(storage_path('app/portraits/').$account->upload_portrait);
            }

            $name = preg_replace('/[^[:alnum:].]/', '', request()
                ->file('upload_portrait')
                ->getClientOriginalName());

            $logoName = $account->id .'_logo_'. $name;

            $account->update([
                "upload_portrait"=>$logoName,
            ]);

            request()
                ->file('upload_portrait')
                ->move(storage_path('app/portraits'), $logoName);

            $logoImage = Image::make(storage_path('app/portraits/') . $logoName);

            $width = $logoImage->width() < $logoImage->height() ? null : 200;
            $height = $logoImage->width() < $logoImage->height() ? 200 : null;
            $logoImage->resize($width, $height, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            });
            $logoImage->save();
        }

        if(request()->get('newsletter')){
            Newsletter::subscribe($user->email);
        }

        $user->assignRole('seller');
        $user->assignRole('seller-active');

        if(!$user->hasPermissionTo('edit account')){
            $user->givePermissionTo("edit account");
        }
        if(!$user->hasPermissionTo('edit account data')){
            $user->givePermissionTo("edit account data");
        }

        if($user->account->couponTemplates()->first()!=null){
            $user->account->couponTemplates()->first()->update([
                'status' => 'active'
            ]);
        }
        $account->status = \App\User::STATUS_ACTIVE;
        $user->update(['status' => \App\User::STATUS_ACTIVE]);
        $account->all_connections = request()->get('all_connections');
        $account->onboarding_process_level +=2;//step over payment-data-view
        $account->syncReceivedSellerRoleAt();
        $account->createMembershipInvoice();
        $user->account->createSepaMandat();
        SellerRegistrationService::applyInvitationBonus($user->account);
        $account->save();
        return redirect('onboarding-seller')
            ->with('notification', $this->notificationSuccess('Profildaten erfolgreich gespeichert.'));
    }
}
