<?php

namespace App\Http\Controllers\Onboarding;


use App\CouponTemplate;
use App\Http\Controllers\UserController;
use App\Http\Requests\OverlayAgentSetProfileRequest;
use App\Library\GeoLocation;
use App\Account;
use App\AccountConnection;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;


class OnboardingAgentController extends Controller
{

    const MAX_LEVEL = 5;
    const MAX_AMOUNT_SHOW_ALL_SELLER = 30;
    const MAX_AMOUNT_SHOW_SELLER = 8;
    const MAX_AMOUNT_SHOW_CONNECTED_ACCOUNTS = 4;
    const SEARCH_RADIUS = 200;

    public function index()
    {
        $account = auth::user()->account;

        if (request('increase') == 1) {
            $account->onboarding_process_level++;
            $account->save();
            return redirect('/onboarding-agent');
        }
        switch ($account->onboarding_process_level) {
            case '0':
                return view('onboarding.agent.welcome');
                break;
            case '1':
                if(auth::user()->surname==''){
                    return view('onboarding.agent.insert-profile-data-after-simple-registration');
                }else{
                    $account->onboarding_process_level++;
                    $account->save();
                    return redirect('/onboarding-agent');
                }
                break;
            case '2':
                if (request('showMaxSeller') == 1) {
                    $allSellers = $this->getSellerWithCouponsByZip(self::MAX_AMOUNT_SHOW_ALL_SELLER, array(), true);
                } else {
                    $allSellers = $this->getSellerWithCouponsByZip(self::MAX_AMOUNT_SHOW_SELLER, array(), true);
                }

                //whereIn will sort to id ascending. Must be avoid.
                //found:https://stackoverflow.com/questions/26176245/laravel-mysql-how-to-order-results-in-the-same-order-as-in-wherein-clause
                $ids_ordered = implode(',', array_fill(0, count($allSellers), '?'));
                if(count($allSellers) > 0){
                    $allSellers = Account::whereIn('id', $allSellers)
                        ->orderByRaw("field(id,{$ids_ordered})", $allSellers)->get();
                }

                return view('onboarding.agent.show_seller', compact('allSellers'));
                break;

            case '3':
                if (request('showMaxSeller') == 1 || request()->session()->get('showAllSellerToRecommend')) {
                    $availableSellersToRecommend = $this->getAccountsToRecommend(self::MAX_AMOUNT_SHOW_ALL_SELLER);
                    $allSellersShown = true;
                    request()->session()->put('showAllSellerToRecommend', true);
                } else {
                    $availableSellersToRecommend = $this->getAccountsToRecommend(self::MAX_AMOUNT_SHOW_SELLER);
                    $allSellersShown = false;
                }

                $ids_ordered = implode(',', array_fill(0, count($availableSellersToRecommend), '?'));
                if(count($availableSellersToRecommend)>0) {
                    $availableSellersToRecommend = Account::whereIn('id', $availableSellersToRecommend)
                        ->orderByRaw("field(id,{$ids_ordered})", $availableSellersToRecommend)->get();
                }else{
                    $availableSellersToRecommend=[];
                }
                return view('onboarding.agent.recommend-seller', compact('availableSellersToRecommend', 'allSellersShown'));

            case '4':
                if (request()->session()->has('showAllSellerToRecommend')) {
                    request()->session()->forget('showAllSellerToRecommend');
                }
                $account->update(['status'=>\App\User::STATUS_ACTIVE]);
                auth::user()->update(['status'=>\App\User::STATUS_ACTIVE]);
                return view('onboarding.agent.complete_tour');
                break;
            default:
                //return redirect("/dashboard/agent");
                return redirect($this->getRealHomeUrl());
        }
    }

    public function noticeSeller()
    {
        $account = auth::user()->account;
        $agentNoticedSeller = request('checkbox-agent-knows-seller');

        if ($agentNoticedSeller != null) {
            foreach ($agentNoticedSeller as $noticedSeller) {
                AccountConnection::create([
                    'account_id' => Auth::user()->account->id,
                    'related_account_id' => $noticedSeller,
                    'type' => 'agent',
                    'status' => 'active'
                ]);

                $accountSeller = Account::find($noticedSeller);
                $accountSeller->users()->first()->email;
                UserController::agentRecommendsSellerFromOverlay($accountSeller);
            }
        }

        $account->onboarding_process_level++;
        $account->save();

        return redirect('/onboarding-agent/');
    }


    public function getAccountsToRecommend($amount)
    {
        $authZip = $this->user->account->zip;
        $agentLocation = GeoLocation::getInstanceByString($authZip);

        $connectedSellerToAgent = auth::user()->account->availableSellerAccountsQuery()->has('couponTemplates')->select('*')->selectRaw("{$agentLocation->getRadiusValue()} as distance")
            ->orderBy('distance')
            ->having('distance', '<', self::SEARCH_RADIUS)->pluck('related_account_id');//Verbindung mit Sellern(gemerkt)

        $connectedSellerToAgentArray = [];

        foreach ($connectedSellerToAgent as $connectedSeller) {
            array_push($connectedSellerToAgentArray, $connectedSeller);
        }
        $connectedSellerToAgentArray = array_slice($connectedSellerToAgentArray, 0, self::MAX_AMOUNT_SHOW_CONNECTED_ACCOUNTS);

        $foundAccounts = $this->getAccountsByAgentLocation($agentLocation);
        $foundAccounts = $foundAccounts->filter(function ($value) {
            foreach ($value->couponTemplates as $couponTemplate) {
                if ($couponTemplate->limitReached() == false && $couponTemplate->coupon_templates_status == CouponTemplate::STATUS_ACTIVE) {
                    return $value;
                }
                return false;
            }
        });
        $foundAccounts = $foundAccounts->pluck('id');
        foreach ($foundAccounts as $foundAccount) {
            $arrayKey = array_search($foundAccount, $connectedSellerToAgentArray);
            if ($arrayKey === false) {
                array_push($connectedSellerToAgentArray, $foundAccount);
            }
        }
        $connectedSellerToAgentArray = array_slice($connectedSellerToAgentArray, 0, $amount);

        return $connectedSellerToAgentArray;

    }


    public function getSellerWithCouponsByZip($amount, $connectedSellerToAgentArray, $inviter = false)
    {
        $authZip = $this->user->account->zip;
        // dd($authZip);
        $agentLocation = GeoLocation::getInstanceByString($authZip);

        $foundAccounts = Account::where('all_connections', 1)
            ->has('couponTemplates')
            ->select('*')
            ->selectRaw("{$agentLocation->getRadiusValue()} as distance")
            ->orderBy('distance')
            ->having('distance', '<', self::SEARCH_RADIUS)
            ->where('upload_portrait', '!=', '')
            ->with(['couponTemplates' => function ($query) {
                $query->withCount('coupons');
                $query->selectRaw('coupon_templates.status as coupon_templates_status');
            }])
            ->get()->filter(function ($value) {
                foreach ($value->couponTemplates as $couponTemplate) {
                    if ($couponTemplate->limitReached() == false && $couponTemplate->coupon_templates_status == CouponTemplate::STATUS_ACTIVE) {
                        return $value;
                    }
                    return false;
                }

            })->pluck('id');


        if ($inviter) {
            $arrayKey = array_search(auth::user()->account->recruiter_user_id, $foundAccounts->toArray());
            if ($arrayKey !== false) {
                unset($foundAccounts[$arrayKey]);
            }
        }
        foreach ($foundAccounts->toArray() as $key => $foundAccount) {
            if (array_search($foundAccount, $connectedSellerToAgentArray) !== false) {
                unset($foundAccounts[$key]);
            }
        }
        $foundAccountsArray = array_slice($foundAccounts->toArray(), 0, $amount);
        return $foundAccountsArray;
        return Account::whereIn('id', $foundAccountsArray)->get();


    }

    public function getAccountsByAgentLocation($agentLocation)
    {
        return Account::where('all_connections', 1)
            ->has('couponTemplates')
            ->select('*')
            ->selectRaw("{$agentLocation->getRadiusValue()} as distance")
            ->orderBy('distance')
            ->having('distance', '<', self::SEARCH_RADIUS)
            ->where('upload_portrait', '!=', '')
            ->with([
                'couponTemplates' => function ($query) {
                    $query->withCount('coupons');
                    $query->selectRaw('coupon_templates.status as coupon_templates_status');
                }])
            ->get();
    }

    public function setProfileData(OverlayAgentSetProfileRequest $request){
        $user = auth::user();
        $user->account->update([
            'zip' => $request->get('zip'),
            'onboarding_process_level' =>  $user->account->onboarding_process_level++
        ]);

        $user->update([
            'firstname'=>$request->get('firstname')
        ]);

        return redirect('/onboarding-agent/');

    }
}