<?php

namespace App\Http\Controllers;

use App\Account;
use App\AccountConnection;
use App\Invitation;
use App\Library\GeoLocation;
use Auth;
use Illuminate\Http\Request;
use App\Http\Requests;
use Illuminate\Support\Facades\Redirect;

class NewsletterController extends Controller
{
    public function agentsInRange($sellerAccount)
    {
        $agentAccounts = Account::allAgentAccounts()->pluck('id');
        $location = GeoLocation::getInstanceByString($sellerAccount->zip);
        $agentAccountsInRange = Account::whereIn('id', $agentAccounts->toArray())
            ->whereRaw($location->getRadiusQuery(25))
            ->get();

        foreach($agentAccountsInRange as $agentAccount){
            $accountConnection = AccountConnection::where('account_id', '=', $agentAccount->id)
                ->where('related_account_id', '=', $sellerAccount->id)
                ->first();

            if(!isset($accountConnection)) {
                $token = str_random();
                $url = url('/newsletter/acceptConnectionViaEmailButton/' .$token);
                $accountConnection = new AccountConnection();
                $accountConnection->AgentNewsletter($sellerAccount, $agentAccount,$token);

                $agentAccount->sendMailToUsers('newsletter-agent', compact('sellerAccount','url'), true);
            }
        }
    }

    public function accept(AccountConnection $accountConnection,$acceptedViaEmail = false)
    {
        $seller = Account::where('id', '=', $accountConnection->related_account_id)->first();
        $agent = Account::where('id', '=', $accountConnection->account_id)->first();

        Auth::login($agent->users()->first());
        if($agent == Auth::user()->account){
            if($seller->all_connections == 1){
                $data = [
                  'type' => AccountConnection::AGENT,
                ];

                $accountConnection->fill($data);
                $accountConnection->save();
                UserController::agentRecommendsSellerFromOverlay($seller);
                if($acceptedViaEmail){
                    return 'Sie können das Unternehmen nun empfehlen.';
                }
                return Redirect::to('invitation')->with('notification', array(
                    'type' => 'success',
                    'title' => 'Akzeptiert',
                    'description' => 'Sie können das Unternehmen nun empfehlen.'
                ));

            }else{
                $invitation = new Invitation();
                $invitation->invite($agent, Invitation::AS_AGENT, $seller);
                $accountConnection->delete();
                if($acceptedViaEmail){
                    return 'Anfrage an das Unternehmen wurde versand.';
                }
                return Redirect::to('invitation')->with('notification', array(
                    'type' => 'success',
                    'title' => 'Akzeptiert',
                    'description' => 'Anfrage an das Unternehmen wurde versand.'
                ));
            }
        }

    }

    public function reject(AccountConnection $accountConnection)
    {
        $accountConnection->reject();
        return Redirect::to('invitation');
    }

    public function acceptConnectionViaEmailButton($token){

        //also check for type, to prevent that the agent can login via button click in email after connection is already confirmed
        $accountConnection = AccountConnection::where('token',$token)->where('type',AccountConnection::NEWSLETTER_REQUEST)->first();
        if(!$accountConnection){
            Auth::logout();
            return Redirect::to('/');
        }
        $description = $this->accept($accountConnection,true);
        return Redirect::to('/dashboard/agent')->with('notification', array(
            'type' => 'success',
            'title' => 'Akzeptiert',
            'description' => $description
        ));
    }
}
