<?php

namespace App\Http\Controllers;

use App\Http\Requests\FileUploadRequest;
use App\Http\Requests\MassInvitationRequest;
use App\Services\LinkInvitationService;
use App\User;
use App\LinkInvitations;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use League\Flysystem\File;
use SimpleSoftwareIO\SMS\Facades\SMS;
use Illuminate\Support\Facades\Validator as ValidatorFactory;
use SimpleSoftwareIO\SMS\SMSNotSentException;

class MassInvitationController extends Controller
{
    public function index()
    {
        $shortlink=Auth::user()->getPermanentShortLink();
        if($shortlink){
            return view('invitation/mass-invitation',compact('shortlink'));
        }
        return view('invitation/mass-invitation');
    }

    protected function isValid($value, $pattern)
    {
        $attribute = 'attribute';
        $validator = ValidatorFactory::make( [ $attribute => $value ], [
            $attribute => $pattern
        ] );
        return !$validator->fails();

    }

    protected function cleanContacts($contacts)
    {
        $contacts = preg_split('#\r\n?|\n\n#', $contacts);

        $contacts = array_filter($contacts, function($value) {
            return !empty(trim($value));
        });

        return $contacts;
    }
    /*
     * MassInvitation is only for sellers to invite agents #28670
     *
     */
    public function create(Request $request)
    {
        $linkInvitationService = new LinkInvitationService();
        $linkInvitation = $linkInvitationService->create(LinkInvitations::REASON_INVITE_NEW_AGENT);

        $url = url('/registration/' . $linkInvitation->token);

        $contacts = $this->cleanContacts($request->get('contacts'));

        $report = [];
        foreach ($contacts as $contact){
            $tempUser = new User();
            if($this->isValid($contact, 'email')) {
                $tempUser->email = $contact;

                $tempUser->sendMail( 'seller-mass-invitation-new-agents', [
                    'sellerAccount' => Auth::user()->account,
                    'url'           => $url
                ] );
                $report[$contact] = 'E-Mail wird verschickt';
            } else {
                $report[$contact] = 'Keine gültige Email Adresse.';
            }
        }

        return view('invitation/mass-invitation-result', compact('report'));

    }

    public function upload(FileUploadRequest $request)
    {
        $contactsFile = $request->file('file');
        $contacts = \File::get($contactsFile->getRealPath());

        $contacts = implode(PHP_EOL, $this->cleanContacts($contacts));

        return view('invitation/mass-invitation', compact('contacts'));

    }
}
