<?php

namespace App\Http\Controllers;

use App\Transaction;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

use App\Invoice;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;

use App\Coupon;
use App\CouponTemplate;

use Storage;

class InvoiceController extends Controller
{
    
    const NO_ACCESS = array(
            'type' => 'error',
            'title' => 'Fehler',
            'description' => 'Kein Zugriff auf dieses Dokument.'
        );
    
    public function _construct(){
        parent::__construct();
        $this->middleware(['auth', 'completed.profile']);
    }
        
    public function downloadPdf( Invoice $invoice ){
        if (!Auth::user()->hasRole('operator')) {
            $transaction = $invoice->transactions->first();

            $user = Auth::user();
            if (!$transaction->user->id == $user->id) {
                return Redirect::back()->with('notification', self::NO_ACCESS);
            }
        }

        //Since root of driver will not be prepended
        $file = storage_path('app/public/invoice/pdf/' . $invoice->pdf_path);
        $headers = array(
            'Content-Type: application/pdf',
        );

        return response()->download($file, null, $headers);
    }
}
