<?php

namespace App\Http\Controllers;

use App\Account;
use App\Coupon;
use App\Intermediarie;
use App\Invitation;
use App\Library\Grids\FieldConfig;
use App\Library\Grids\MinimalGrid;
use App\Library\Grids\GridConfig;
use App\User;
use App\AccountConnection;
use Illuminate\Http\Request;
use App\Http\Requests;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Redirect;
use Nayjest\Grids\DbalDataProvider;
use Nayjest\Grids\EloquentDataProvider;
use Nayjest\Grids\FilterConfig;

class InvitationController extends Controller
{
    public function _construct(){
        parent::__construct();
        $this->middleware(['auth', 'completed.profile']);
    }

    public function index()
    {
        $invitations = Invitation::query()
            ->where('invited_account_id', '=', Auth::user()->account->id)
            ->where('status', '=', Invitation::STATUS_PENDING)
            ->where('required_role', '=', 'as agent')
            ->get()->filter(function($value){
                if($value->account && $value->account->status == User::STATUS_ACTIVE){
                    return $value;
                }else{
                    return;
                }
            });

        $coupons = Coupon::query()
            ->where('consumer_user_id', '=', Auth::user()->id)
            ->where('status', '=', Invitation::STATUS_PENDING)
            ->get();

        $intermediaries = Invitation::query()
            ->where('invited_account_id', '=', Auth::user()->account->id)
            ->where('status', '=', Invitation::STATUS_PENDING)
            ->where('required_role', '=', 'to agent')
            ->get()->filter(function($value){
                if($value->account && $value->account->status == User::STATUS_ACTIVE){
                    return $value;
                }else{
                    return;
                }
            });

        $newsletters = AccountConnection::where('account_id', '=', Auth::user()->account->id)
            ->where('type', '=', AccountConnection::NEWSLETTER_REQUEST)
            ->where('status', '=', AccountConnection::STATUS_ACTIVE)
            ->get()->filter(function($value){
                $relatedAccount = Account::find($value->related_account_id);
                if($relatedAccount){
                    return $value;
                }else{
                    return;
                }
            });

        return view('invitation/index', [
            'invitations' => $invitations,
            'coupons' => $coupons,
            'intermediaries' => $intermediaries,
            'newsletters' => $newsletters
        ]);
    }

    public function accept(Invitation $invitation)
    {
	    $agent = $invitation->getAgent();
	    $seller = $invitation->getSeller();

        if ($invitation->required_role == Invitation::TO_AGENT) {
	        $seller->sendMailToUsers('agent-has-accepted-invitation-as-recommender', compact('user', 'agent', 'seller'));

            // FIXME: ins model Invitation->createConnection()
            $accountConnection = [
                'account_id' => $invitation->invited_account_id,
                'related_account_id' => $invitation->account_id,
                'type' => 'agent',
                'status' => 'active'
            ];
        } elseif ($invitation->required_role == Invitation::AS_AGENT) {
            // FIXME: logic problem: https://tracker.imi.de/issues/18027#note-14
            //if(!$invitedAccount->hasRole('agent')) {
            //    $invitedAccount->assignRole('agent');
            //}
            $url = route('share-coupons-from-seller', $seller->id);
            $agent->sendMailToUsers('agent-accepted-by-company-as-recommender', compact('user', 'seller', 'url', 'agent'));

            // FIXME: ins model Invitation->createConnection() / siehe oben
            $accountConnection = [
                'account_id' => $invitation->account_id,
                'related_account_id' => $invitation->invited_account_id,
                'type' => 'agent',
                'status' => 'active'
            ];
        } else {
            throw new \Exception('Invalid required role');
        }

        AccountConnection::create($accountConnection);
        // TODO? maybe we do not want to delete old invitations (status = accepted)
        $invitation->delete();

        return Redirect::to('invitation')->with('notification', array(
            'type' => 'success',
            'title' => 'Akzeptiert',
            'description' => 'Die Einladung wurde akzeptiert.'
        ));
    }

    public function reject(Invitation $invitation)
    {
        $invitation->reject();

        return Redirect::to('invitation')->with('notification', array(
            'type' => 'success',
            'title' => 'Abgelehnt',
            'description' => 'Die Einladung wurde abgelehnt.'
        ));
    }
}
