<?php

namespace App\Http\Controllers;

use App\FAQ;

class IndexController extends Controller
{
    public function thankYou()
    {
	    return view('redesign.auth.register_successful');
    }

    public function imprint()
	{
		return view('/imprint');
	}

	public function contact(){
        return view('/contact');
    }

    public function advantages(){
	    return view('landingpages/seller/vorteile-entdecken');
    }

	public function shortLink($code)
	{
		return redirect(\App\Shortlink::getOriginalLink($code));
	}

    public function workInProgress()
    {
        return view('redesign.front.works');
    }

    public function agb()
    {
        return view('redesign.front.static.agb');
    }

    public function privacy()
    {
        return view('redesign.front.static.privacy');
    }

    public function impressum()
    {
        return view('redesign.front.static.impressum');
    }

    public function faq()
    {
        return view('redesign.front.static.faq', [
            'faq' => FAQ::getGrouped(['agent', 'consumer']),
        ]);
    }

    public function business()
    {
        return view('redesign.front.business.index');
    }

    public function landing()
    {
        return view('redesign.front.home.index');
    }
}
