<?php

namespace App\Http\Controllers;

use App\User;

class ImageController extends Controller
{
    public function getImage($upload_portrait)
    {
        $path = storage_path('app/portraits/') . $upload_portrait;

        return response()->download($path, null, [], 'inline');
    }

    /**
     * Method to get userpic (logo for seller or avatar for user).
     *
     * @param User $user
     * @return string|\Symfony\Component\HttpFoundation\BinaryFileResponse
     */
    public function getUserpic(User $user)
    {
        // TODO remove old routes and methods
        // TODO change to hasTrait using

        if ($user && $user->hasRole('seller') && '' !== $user->account->upload_portrait) {
            $path = storage_path('app/portraits/') . $user->account->upload_portrait;
            return response()->download($path, null, [], 'inline');
        } else if ($user && '' !== $user->upload_portrait) {
            $path = storage_path('app/portraits/') . $user->upload_portrait;
            return response()->download($path, null, [], 'inline');
        } else {
            return asset('img/logo_company.png');
        }
    }
}
