<?php

namespace App\Http\Controllers;


use App\Category;
use App\CouponTemplate;
use App\User;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user = Auth::user();

        // temporary show landing
        if (!$user) {
            //return view('redesign.landings.game.index');
        }

        if ( !config('recoma.openedSystem', false) ) {
            return redirect($this->getRealHomeUrl());
        } else if ($user && $user->hasRole(User::OPERATOR)) {
            return redirect(url('/dashboard/operator'));
        } else if ($user && $user->hasRole(User::SELLER)) {
            return redirect(url('/dashboard/seller'));
        }

        $top = CouponTemplate::available()->top()->limit(9)->get();
        $categories = Category::getPopular(6);

        return view('redesign.front.home.index', [
            'top' => $top,
            'categories' => $categories,
        ]);
    }
	
	public function landing()
    {
        $top = CouponTemplate::available()->top()->limit(9)->get();
        $categories = Category::getPopular(6);

        return view('redesign.front.home.index', [
            'top' => $top,
            'categories' => $categories,
        ]);
    }
}