<?php

namespace App\Http\Controllers;

use App\CouponTemplate;
use App\Services\FilterService;
use App\Services\SortingService;
use App\Services\TitleService;

class DealsController extends Controller
{
    /**
     * Method to show deals page.
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $filterService = new FilterService();

        $deals             = CouponTemplate::getAvailableDeals();
        $title             = (new TitleService())->renderDealsTitle();
        $sortings          = (new SortingService())->getSortings();
        $filters           = $filterService->getFilters();
        $geoLocationFilter = $filterService->getGeoLocationFilter();

        $top = $deals->count()
            ? collect([])
            : CouponTemplate::available()->top()->limit(10)->get();

        return view('redesign.front.deals.index', [
            'top'               => $top,
            'title'             => $title,
            'deals'             => $deals,
            'filters'           => $filters,
            'sortings'          => $sortings,
            'geoLocationFilter' => $geoLocationFilter,
        ]);
    }

    /**
     * Method to show seller deals list.
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function sellerIndex()
    {
        $deals = CouponTemplate::with('provisionGift', 'discountGift')
            ->withCount('coupons', 'couponsRedeemed')
            ->where('user_id', $this->getSeller()->id)
            ->where('status', '<>', CouponTemplate::STATUS_DRAFT)
            ->where('status', '<>', CouponTemplate::STATUS_DELETED)
            ->orderBy('title')
            ->get();

        return view('redesign.back.metronic.deals.index', [
            'deals'  => $deals,
        ]);
    }
}
