<?php

namespace App\Http\Controllers;

use App\Transfer;
use Auth;

use App\Transaction;
use App\CreditNote;
use Carbon\Carbon;
use Illuminate\Support\Facades\Redirect;

class CreditNoteController extends Controller
{
    
    const NO_ACCESS = array(
            'type' => 'error',
            'title' => 'Fehler',
            'description' => 'Kein Zugriff auf dieses Dokument.'
        );
    
    public function _construct(){
        parent::__construct();
        $this->middleware(['auth', 'completed.profile']);
    }
    
    public function downloadPdf( CreditNote $creditNote ){
        if (!Auth::user()->hasRole('operator')) {
            $transaction = $creditNote->transaction;

            if( !( $transaction instanceof Transaction ) ){
                return Redirect::back()->with('notification',self::NO_ACCESS );
            }

            $user = Auth::user();
            if( $user->id != $transaction->user->id ){
                return Redirect::back()->with('notification', self::NO_ACCESS);
            }
        }

        //Since root of driver will not be prepended
        $file = storage_path('app/public/creditnote/pdf/' . $creditNote->pdf_path);
        $headers = array(
            'Content-Type: application/pdf',
        );

        return response()->download($file, null, $headers);
    }

    /**
     * sum values from done seller-operator-provisions, fees and create a xml file for download
     *
     * @return \Symfony\Component\HttpFoundation\BinaryFileResponse
     */
    public function transfer()
    {
        // TODO add money from gifts
        $transfers = Transaction::whereIn(
            'type',
            [
                Transaction::TYPE_SELLER_OPERATOR_PROVISION_PAYMENT,
                Transaction::TYPE_SELLER_FEE_MONTHLY_PAYMENT,
                Transaction::TYPE_SELLER_FEE_YEARLY_PAYMENT,
            ])
            ->whereStatus(Transaction::STATUS_PAID)
            ->where('transfer_date', '=', null)
            ->get();

        $transferSum = $transfers->sum('amount') * -1;
        if($transferSum == 0){
            return Redirect::to('/transaction')->with('notification', array(
                'type' => 'warning',
                'title' => 'Nicht Umbuchbar',
                'description' => 'Der Wert der Umbuchung muss größer als 0€ sein.'
            ));
        }
        $file = Transfer::generateTransferCreditXml($transferSum);

        $date = Carbon::now();
        foreach($transfers as $transfer){
            $transfer->transfer_date = $date;
            $transfer->save();
        }

        return response()->download(storage_path('app/transfer/') . $file . '.xml');

    }
}


