<?php

namespace App\Http\Controllers;

use App\BankTransaction;
use App\Http\Grids\BankTransactionGrid;
use App\Http\Grids\Operator\JobQueueGrid;
use App\Http\Requests;
use App\Invoice;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;


class BankTransactionController extends Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->middleware(['auth', 'completed.profile']);
        if (!Auth::user()->hasPermission('show operator transactions')) {
            throw new \Exception('Permission denied');
        }
    }

    public function index()
    {
        return view('bank_transaction/index', [
            'grid' => new BankTransactionGrid()
        ]);
    }

    public function showSetStatus(BankTransaction $bankTransaction)
    {
        $invoices = \App\Invoice::where('bank_transaction_id', '=', null)->get();
        $creditnotes = \App\CreditNote::where('bank_transaction_id', '=', null)->get();

        return view('bank_transaction/set-status', compact('bankTransaction', 'invoices', 'creditnotes'));
    }

    public function setStatus(Request $request)
    {
        if ($request->invoice_id){
            $invoiceOrCreditnote = \App\Invoice::where('id', '=', $request->invoice_id)->first();
        } elseif ($request->creditnote_id){
            $invoiceOrCreditnote = \App\CreditNote::where('id', '=', $request->creditnote_id)->first();
        }

        $invoiceOrCreditnote->bank_transaction_id = $request->bank_transaction_id;
        $invoiceOrCreditnote->save();

        $banktransaction = BankTransaction::where('id', '=', $request->bank_transaction_id)->first();
        $banktransaction->assignBankTransaction($invoiceOrCreditnote);

        return Redirect::to('bank_transaction')->with('notification', array(
            'type' => 'success',
            'title' => 'Erfolg',
            'description' => 'Zuweisung erfolgreich.'
        ));
    }
}
