<?php

namespace App\Http\Controllers\API;

use App\Http\Requests\UsersGiftReceivedRequest;
use App\Http\Requests\UsersGiftRequest;
use App\Services\UsersGiftService;
use App\UsersGift;

class UsersGiftController extends Controller
{
    /**
     * Method to set gift address.
     *
     * @param UsersGiftRequest $request
     * @param UsersGift $usersGift
     * @return \Illuminate\Http\JsonResponse
     */
    public function setAddress(UsersGiftRequest $request, UsersGift $usersGift)
    {
        $requestData = $this->getRequestData($request);

        (new UsersGiftService($usersGift))->setAddress($requestData);

        return $this->_s();
    }

    /**
     * Method to mark gift as received.
     *
     * @param UsersGiftReceivedRequest $request
     * @param UsersGift $usersGift
     * @return \Illuminate\Http\JsonResponse
     */
    public function markAsReceived(UsersGiftReceivedRequest $request, UsersGift $usersGift)
    {
        (new UsersGiftService($usersGift))->markAsReceived();

        return $this->_s();
    }
}